@echo off
@setlocal enableextensions enabledelayedexpansion

(set NOT_LAUNCHED_FROM_PROMPT=)
(set TEST_FAILED=)
for %%x in (%cmdcmdline%) do if %%~x==/c set NOT_LAUNCHED_FROM_PROMPT=1

set NETFX_VERSION=4.0.30319
set BUILD="%WINDIR%\Microsoft.NET\Framework\v%NETFX_VERSION%\MSBuild.exe"
set TEST="%ProgramFiles(x86)%\Microsoft Visual Studio 10.0\Common7\IDE\MSTest.exe"
set BUILD_LOG_FILE=buildlog.txt
set TEST_LOG_FILE=testlog.txt


::
:: Build all .sln
::
del %BUILD_LOG_FILE%
for /R ..\ %%F in (*.sln) do (
  echo Compiling %%~nF...
  %BUILD% %%F /p:Configuration=Debug /p:Platform="Any CPU" >> %BUILD_LOG_FILE%
  if %errorlevel% neq 0 (
    echo There were build errors. Fix them first. See %BUILD_LOG_FILE% for details.
    if defined NOT_LAUNCHED_FROM_PROMPT pause
    exit /b %errorlevel%
  ) else echo OK
  echo. >> %BUILD_LOG_FILE%
)

::
:: Browse through all .dll and try to run tests
:: Beware of the compilation temporary dlls
:: (hence the "TestResults" string matching)
::
del %TEST_LOG_FILE%
for /R ..\ %%F in (*test.dll *tests.dll) do (
  set name=%%F
  set trimmed=!name:TestResults=!
  if !trimmed!==!name! (
    echo Running tests from %%~nxF...
    %TEST% /testcontainer:%%F >> %TEST_LOG_FILE%
    if errorlevel 1 (
      set TEST_FAILED=1
    echo Fail
    ) else echo Success
    echo. >> %TEST_LOG_FILE%
  )
)

if defined TEST_FAILED echo There were failed tests. See %TEST_LOG_FILE% for details.
if defined NOT_LAUNCHED_FROM_PROMPT pause

endlocal
